﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis;

namespace WCF_BusinessManagerAHOBPRTests.EMIS
{
    [TestClass]
    public class EdipiValidatorTests
    {
        [TestMethod]
        public void EdipiValidator_Returns_False_When_Given_Letter()
        {
            var actual = EdipiValidator.IsValid("x");
            Assert.AreEqual(false, actual);
        }
        [TestMethod]
        public void EdipiValidator_Returns_False_When_Given_Ten_Character_String()
        {
            var actual = EdipiValidator.IsValid("xxxxxxxxxx");
            Assert.AreEqual(false, actual);
        }
        [TestMethod]
        public void EdipiValidator_Returns_True_With_Ten_Digit_EDIPI()
        {
            var actual = EdipiValidator.IsValid("1234567890");
            Assert.AreEqual(true, actual);
        }
        [TestMethod]
        public void EdipiValidator_Returns_False_With_Ten_Digit_Mix_Of_Characters_And_Numbers()
        {
            var actual = EdipiValidator.IsValid("12345678A0");
            Assert.AreEqual(false, actual);
        }
        [TestMethod]
        public void EdipiValidator_Returns_False_With_More_Than_Ten_Number_EDIPI()
        {
            var actual = EdipiValidator.IsValid("123456789012");
            Assert.AreEqual(false, actual);
        }
        [TestMethod]
        public void EdipiValidator_Returns_False_When_Given_Non_Text()
        {
            var actual = EdipiValidator.IsValid("x*&");
            Assert.AreEqual(false, actual);
        }
    }
}
